Public Class Building
  ' This is the base class, from which we derive the
  ' apartment, commercial, and home classes.

  ' =============== Symbolic Constants ================
  Private Const APARTMENT As Integer = 0
  Private Const COMMERCIAL As Integer = 1
  Private Const HOME As Integer = 2

  ' ================== Data Members ==================

  Private mAddress As String          ' Street address
  Private mPrice As Double            ' Purchase price
  Private mMonthlyPayment As Double   ' Monthly payment
  Private mTaxes As Double            ' Annual taxes
  Private mType As Integer            ' Building type


  ' ==================== Properties ======================
  Property Address()            ' Address Property
    Get
      Return mAddress
    End Get

    Set(ByVal Value)
      mAddress = Value
    End Set
  End Property

  Public Property PurchasePrice()     ' Purchase Price Property
    Get
      Return mPrice
    End Get

    Set(ByVal Value)
      mPrice = Value
    End Set
  End Property

  Public Property MonthlyPayment()    ' Monthly Payment Property
    Get
      Return mMonthlyPayment
    End Get

    Set(ByVal Value)
      mMonthlyPayment = Value
    End Set
  End Property

  Public Property Taxes()             ' Property Taxes Property
    Get
      Return mTaxes
    End Get

    Set(ByVal Value)
      mTaxes = Value
    End Set
  End Property

  Public Property BuildingType()      ' Building Type Property
    Get
      Return mType
    End Get

    Set(ByVal Value)
      If Value < APARTMENT Or Value > HOME Then
        mType = -1    ' an error
      Else
        mType = Value
      End If
    End Set
  End Property

  ' ========================== Methods ========================
  Protected Sub DisplayBaseInfo()
    Dim BldType As String

    ' Purpose:  To display the base member data
    Console.WriteLine("Address: " & mAddress)
    Console.WriteLine("Purchase Price: " & FormatMoney(mPrice))
    Console.WriteLine("Monthly Payment: " & FormatMoney(mMonthlyPayment))
    Console.WriteLine("Property Taxes: " & FormatMoney(mTaxes))
    Select Case mType
      Case APARTMENT
        BldType = "Apartment"
      Case COMMERCIAL
        BldType = "Commercial"
      Case HOME
        BldType = "Home"
    End Select
    Console.WriteLine("Building Type: " & BldType)
  End Sub

  ' =========================== Helpers =========================
  Protected Function FormatMoney(ByVal num As Double) As String
    ' Purpose:  To format a dollar value
    '
    ' Argument list:
    '   num         A double that is the dollar value to format
    '
    ' Return value:
    '   string      A format dollar value string

    Return Format(num, "$#,###,###,###.00")
  End Function
End Class

' ++++++++++++++++++++++++++++ Aparment Class ++++++++++++++++++++++++
Public Class Apartment
  Inherits Building

  Private mUnits As Integer     ' The number of apartments
  Private mRent As Double       ' Rent per unit
  Private mOccupRate As Double  ' Occupance rate for building

  ' ==================== Properties ======================

  Public Property Units()       ' Units
    Get
      Return mUnits
    End Get
    Set(ByVal Value)
      mUnits = Value
    End Set
  End Property

  Public Property Rents()       ' Rents
    Get
      Return mRent
    End Get
    Set(ByVal Value)
      mRent = Value
    End Set
  End Property

  Public Property OccupancyRate() ' Occupancy rate
    Get
      Return mOccupRate
    End Get
    Set(ByVal Value)
      mOccupRate = Value
    End Set
  End Property

  ' ============== Methods ==================
  Public Sub DisplayBuilding()

    DisplayBaseInfo()
    Console.WriteLine("Number of Units: " & mUnits)
    Console.WriteLine("Rent per Unit: " & FormatMoney(mRent))
    Console.WriteLine("Occupancy Rate: " & mOccupRate)
  End Sub
End Class

' ++++++++++++++++++++++++++++ Commercial Class ++++++++++++++++++++++++++++

Public Class Commercial
  Inherits Building

  Private mSquareFeet As Integer    ' Rentable square feet
  Private mRentPerSF As Double      ' Rent per square foot
  Private mParking As Integer       ' Parking spots

  ' ==================== Properties ======================
  Public Property SquareFeet()      ' Square feet
    Get
      Return mSquareFeet
    End Get
    Set(ByVal Value)
      mSquareFeet = Value
    End Set
  End Property

  Public Property RentPerSF()       ' Rent per square foot
    Get
      Return mRentPerSF
    End Get
    Set(ByVal Value)
      mRentPerSF = Value
    End Set
  End Property

  Public Property ParkingSpots()    ' Parking spots
    Get
      Return mParking
    End Get
    Set(ByVal Value)
      mParking = Value
    End Set
  End Property

  ' ============== Methods ==================

  Public Sub DisplayBuilding()
    DisplayBaseInfo()               ' Call base class
    Console.WriteLine("Square Feet: " & mSquareFeet)
    Console.WriteLine("Rent per SF: " & FormatMoney(mRentPerSF))
    Console.WriteLine("Parking Spots: " & mParking)
  End Sub
End Class

' ++++++++++++++++++++++++++++ Home Class ++++++++++++++++++++++++++++

Public Class Home
  Inherits Building

  Private mSquareFeet As Integer      ' Home's square feet
  Private mRentPerMonth As Double     ' Rent per month
  Private mBedrooms As Integer        ' Number of bedrooms
  Private mBaths As Integer           ' Number of bathrooms

  ' ==================== Properties ======================
  Public Property SquareFeet()        ' Square feet
    Get
      Return mSquareFeet
    End Get
    Set(ByVal Value)
      mSquareFeet = Value
    End Set
  End Property

  Public Property Rent()              ' Rent
    Get
      Return mRentPerMonth
    End Get
    Set(ByVal Value)
      mRentPerMonth = Value
    End Set
  End Property

  Public Property Bedrooms()          ' Bedrooms
    Get
      Return mBedrooms
    End Get
    Set(ByVal Value)
      mBedrooms = Value
    End Set
  End Property

  Public Property Baths()             ' Baths
    Get
      Return mBaths
    End Get
    Set(ByVal Value)
      mBaths = Value
    End Set
  End Property

  ' ============== Methods ==================
  Public Sub DisplayBuilding()

    DisplayBaseInfo()               ' Call base class
    '    Console.WriteLine("Building Type: Home")
    Console.WriteLine("Square Feet: " & mSquareFeet)
    Console.WriteLine("Rent per Month: " & FormatMoney(mRentPerMonth))
    Console.WriteLine("Bedrooms: " & mBedrooms)
    Console.WriteLine("Baths: " & mBaths)
  End Sub
End Class